using System;
using Server;

namespace Server.Items
{
	public class GSOrb : PeerlessKey
	{	
		public override int Lifespan{ get{ return 18000; } }
	
		[Constructable]
		public GSOrb() : base( 6249 )
		{
			Weight = 1152;
			Stackable = false;
			Name = "A Mysterious Stone";
			Weight = 1.0;
			Amount = 1;
			Hue = 1152;
		}
		
		public override void OnDoubleClick( Mobile from )
		{
			Container pack = from.Backpack;

			if ( !IsChildOf( from.Backpack ) )
			{
				from.SendLocalizedMessage( 1042001 ); // That must be in your pack for you to use it.
			} 
			else
			{
				from.SendMessage( "The Orb seperates into 4 spheres" );

				from.AddToBackpack( new GTele1() );
				from.AddToBackpack( new GTele2() );
				from.AddToBackpack( new GTele3() );
				from.AddToBackpack( new GTele4() );

				this.Delete();
			}
		}

		public GSOrb( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );
			
			writer.Write( (int) 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );
			
			int version = reader.ReadInt();
		}
	}
}

